<?php 
include 'db.php';
include 'header.php'; // Tasarımın çatısı

$user_id = $_SESSION['user_id'];

// --- VERİ ÇEKME İŞLEMLERİ ---
$sorgu = $db->prepare("SELECT * FROM islemler WHERE user_id = ? ORDER BY tarih DESC");
$sorgu->execute([$user_id]);
$islemler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

$gelir = 0; $gider = 0;
foreach($islemler as $i) {
    if($i['tur'] == 'gelir') $gelir += $i['miktar'];
    else $gider += $i['miktar'];
}
$bakiye = $gelir - $gider;

// Son 6 işlem (Listeyi biraz uzattık)
$sonIslemler = array_slice($islemler, 0, 6);

// Grafik Verisi
$grafikSql = $db->prepare("SELECT kategori, tur, SUM(miktar) as toplam FROM islemler WHERE user_id = ? GROUP BY kategori");
$grafikSql->execute([$user_id]);
$grafikVeri = $grafikSql->fetchAll(PDO::FETCH_ASSOC);

$g_etiketler = [];
$g_veri = [];
foreach($grafikVeri as $v) {
    $g_etiketler[] = $v['kategori'];
    $g_veri[] = $v['toplam'];
}

// Akıllı Selamlama (Saate Göre)
$saat = date("H");
$selam = "Merhaba";
if ($saat < 12) $selam = "Günaydın";
elseif ($saat < 18) $selam = "İyi Günler";
else $selam = "İyi Akşamlar";
?>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
    .no-scrollbar::-webkit-scrollbar { display: none; }
    .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
</style>

<div class="max-w-7xl mx-auto">

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-10">
        
        <div class="lg:col-span-2 bg-midnight rounded-3xl p-8 text-white relative overflow-hidden shadow-2xl shadow-midnight/30 flex flex-col justify-between min-h-[220px]">
            
            <div class="absolute top-0 right-0 w-64 h-64 bg-sunburst/20 rounded-full blur-3xl -mr-16 -mt-16 pointer-events-none"></div>
            <div class="absolute bottom-0 left-0 w-40 h-40 bg-blue-500/20 rounded-full blur-2xl -ml-10 -mb-10 pointer-events-none"></div>
            
            <div class="relative z-10 flex justify-between items-start">
                <div>
                    <div class="text-slate-300 font-medium text-sm mb-1"><?= $selam ?>,</div>
                    <h1 class="text-3xl font-bold tracking-tight"><?= explode(" ", $_SESSION['ad_soyad'])[0] ?> 👋</h1>
                </div>
                <a href="ekle.php" class="bg-white/10 hover:bg-white/20 backdrop-blur-md border border-white/10 text-white px-5 py-2.5 rounded-xl text-sm font-bold transition-all flex items-center gap-2">
                    <i class="fa-solid fa-plus text-sunburst"></i> İşlem
                </a>
            </div>

            <div class="relative z-10 mt-6">
                <div class="text-slate-400 text-xs font-bold uppercase tracking-widest mb-1">TOPLAM NET VARLIK</div>
                <div class="flex items-baseline gap-2">
                    <span class="text-5xl font-extrabold tracking-tighter"><?= number_format($bakiye, 2) ?></span>
                    <span class="text-2xl font-medium text-sunburst">₺</span>
                </div>
            </div>
        </div>

        <div class="lg:col-span-1 flex flex-col gap-5">
            
            <div class="flex-1 bg-white p-6 rounded-3xl shadow-sm border border-slate-100 flex items-center justify-between group hover:border-emerald-200 transition-colors">
                <div>
                    <div class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">BU AY GELİR</div>
                    <div class="text-2xl font-extrabold text-emerald-600">+<?= number_format($gelir, 2) ?> ₺</div>
                </div>
                <div class="w-12 h-12 bg-emerald-50 rounded-2xl flex items-center justify-center text-emerald-600 text-xl group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-arrow-trend-up"></i>
                </div>
            </div>

            <div class="flex-1 bg-white p-6 rounded-3xl shadow-sm border border-slate-100 flex items-center justify-between group hover:border-rose-200 transition-colors">
                <div>
                    <div class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">BU AY GİDER</div>
                    <div class="text-2xl font-extrabold text-rose-600">-<?= number_format($gider, 2) ?> ₺</div>
                </div>
                <div class="w-12 h-12 bg-rose-50 rounded-2xl flex items-center justify-center text-rose-600 text-xl group-hover:scale-110 transition-transform">
                    <i class="fa-solid fa-arrow-trend-down"></i>
                </div>
            </div>

        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        
        <div class="lg:col-span-2 bg-white rounded-3xl p-8 shadow-lg shadow-slate-200/50 border border-slate-100">
            <div class="flex justify-between items-center mb-8">
                <h3 class="text-xl font-bold text-midnight flex items-center gap-2">
                    <i class="fa-solid fa-chart-simple text-sunburst"></i> Harcama Analizi
                </h3>
                <a href="rapor.php" class="text-xs font-bold text-slate-400 hover:text-midnight transition-colors uppercase tracking-wider border-b border-transparent hover:border-midnight pb-0.5">Raporu Gör</a>
            </div>
            
            <div class="relative w-full h-80">
                <?php if(count($g_etiketler) > 0): ?>
                    <canvas id="mainChart"></canvas>
                <?php else: ?>
                    <div class="h-full flex flex-col items-center justify-center text-slate-300">
                        <i class="fa-solid fa-chart-column text-5xl mb-3 opacity-50"></i>
                        <p class="font-medium">Henüz analiz edilecek veri yok.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="lg:col-span-1 bg-white rounded-3xl p-8 shadow-lg shadow-slate-200/50 border border-slate-100 flex flex-col h-[460px]">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-xl font-bold text-midnight">Son Hareketler</h3>
                <a href="liste.php" class="w-8 h-8 rounded-full bg-slate-50 text-slate-400 hover:bg-midnight hover:text-white flex items-center justify-center transition-all">
                    <i class="fa-solid fa-arrow-right text-sm"></i>
                </a>
            </div>

            <div class="flex-1 overflow-y-auto no-scrollbar space-y-4 pr-1">
                <?php foreach($sonIslemler as $row): 
                    $isGelir = ($row['tur'] == 'gelir');
                    $renk = $isGelir ? 'text-emerald-600' : 'text-rose-600';
                    $bg = $isGelir ? 'bg-emerald-50' : 'bg-rose-50';
                    $ikon = $isGelir ? 'fa-arrow-up' : 'fa-arrow-down';
                ?>
                <div class="flex items-center justify-between p-3 rounded-2xl hover:bg-slate-50 transition-colors cursor-pointer group">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 <?= $bg ?> rounded-xl flex items-center justify-center <?= $renk ?> text-base shadow-sm group-hover:scale-110 transition-transform">
                            <i class="fa-solid <?= $ikon ?>"></i>
                        </div>
                        <div>
                            <div class="font-bold text-slate-800 text-sm group-hover:text-midnight"><?= htmlspecialchars($row['aciklama']) ?></div>
                            <div class="text-xs text-slate-400 font-medium mt-0.5"><?= $row['kategori'] ?></div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="text-sm font-bold <?= $renk ?> font-mono">
                            <?= $isGelir ? '+' : '-' ?><?= number_format($row['miktar'], 0) ?>
                        </div>
                        <div class="text-[10px] text-slate-300 font-bold"><?= date("d.m", strtotime($row['tarih'])) ?></div>
                    </div>
                </div>
                <?php endforeach; ?>

                <?php if(empty($sonIslemler)): ?>
                    <div class="h-full flex flex-col items-center justify-center text-slate-400 text-center">
                        <i class="fa-regular fa-folder-open text-3xl mb-2 opacity-30"></i>
                        <p class="text-sm">Henüz işlem yok.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

    </div>
</div>

<script>
    const ctx = document.getElementById('mainChart');
    if(ctx) {
        Chart.defaults.font.family = "'Plus Jakarta Sans', sans-serif";
        Chart.defaults.color = '#94a3b8';
        
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: <?= json_encode($g_etiketler) ?>,
                datasets: [{
                    label: 'Tutar',
                    data: <?= json_encode($g_veri) ?>,
                    backgroundColor: '#f59e0b',
                    borderRadius: 8,
                    borderSkipped: false,
                    barThickness: 28,
                    hoverBackgroundColor: '#d97706'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false } },
                scales: {
                    y: { 
                        grid: { borderDash: [6, 6], color: '#f1f5f9', drawBorder: false }, 
                        beginAtZero: true,
                        ticks: {
                            font: { size: 11, weight: '600' }
                        }
                    },
                    x: { 
                        grid: { display: false },
                        ticks: { font: { size: 11, weight: '600' }, color: '#64748b' }
                    }
                }
            }
        });
    }
</script>

</main>
</div>
</body>
</html>