<?php 
include 'db.php';
include 'header.php'; 

// URL Kontrolü
if (!isset($_GET['id'])) {
    header("Location: liste.php");
    exit;
}

$id = $_GET['id'];
$user_id = $_SESSION['user_id'];

// 1. İşlem Verisini Çek
$sorgu = $db->prepare("SELECT * FROM islemler WHERE id = ? AND user_id = ?");
$sorgu->execute([$id, $user_id]);
$kayit = $sorgu->fetch(PDO::FETCH_ASSOC);

if (!$kayit) {
    header("Location: liste.php");
    exit;
}

// 2. Kategorileri Çek (Dinamik)
$katSorgu = $db->prepare("SELECT * FROM kategoriler WHERE user_id = ? ORDER BY ad ASC");
$katSorgu->execute([$user_id]);
$dbKategoriler = $katSorgu->fetchAll(PDO::FETCH_ASSOC);

$jsGiderler = [];
$jsGelirler = [];

foreach($dbKategoriler as $k) {
    if($k['tur'] == 'gider') $jsGiderler[] = $k['ad'];
    else $jsGelirler[] = $k['ad'];
}
?>

<div class="max-w-2xl mx-auto pt-6">
    
    <div class="mb-8 text-center">
        <h1 class="text-3xl font-bold text-midnight mb-2">İşlem Düzenle</h1>
        <p class="text-slate-500 font-medium">Mevcut kaydı güncelle.</p>
    </div>

    <div class="card-panel shadow-2xl border-0 p-0 overflow-hidden">
        <form action="islem.php" method="POST">
            
            <input type="hidden" name="id" value="<?= $kayit['id'] ?>">
            <input type="hidden" name="guncelle" value="1">

            <div class="grid grid-cols-2 border-b border-slate-100">
                <label class="cursor-pointer relative">
                    <input type="radio" name="tur" value="gider" class="peer sr-only" <?= $kayit['tur'] == 'gider' ? 'checked' : '' ?> onchange="turDegisti('gider')">
                    <div class="p-6 text-center transition-all peer-checked:bg-red-50 peer-checked:text-red-600 hover:bg-slate-50">
                        <div class="w-12 h-12 mx-auto rounded-full bg-red-100 text-red-600 flex items-center justify-center mb-2 text-xl peer-checked:scale-110 transition-transform">
                            <i class="fa-solid fa-arrow-trend-down"></i>
                        </div>
                        <span class="font-bold block text-sm tracking-wider uppercase">Gider</span>
                    </div>
                    <div class="absolute bottom-0 left-0 w-full h-1 bg-red-500 transform scale-x-0 peer-checked:scale-x-100 transition-transform"></div>
                </label>

                <label class="cursor-pointer relative">
                    <input type="radio" name="tur" value="gelir" class="peer sr-only" <?= $kayit['tur'] == 'gelir' ? 'checked' : '' ?> onchange="turDegisti('gelir')">
                    <div class="p-6 text-center transition-all peer-checked:bg-emerald-50 peer-checked:text-emerald-600 hover:bg-slate-50">
                        <div class="w-12 h-12 mx-auto rounded-full bg-emerald-100 text-emerald-600 flex items-center justify-center mb-2 text-xl peer-checked:scale-110 transition-transform">
                            <i class="fa-solid fa-arrow-trend-up"></i>
                        </div>
                        <span class="font-bold block text-sm tracking-wider uppercase">Gelir</span>
                    </div>
                    <div class="absolute bottom-0 left-0 w-full h-1 bg-emerald-500 transform scale-x-0 peer-checked:scale-x-100 transition-transform"></div>
                </label>
            </div>

            <div class="p-8 space-y-8">
                
                <div class="text-center">
                    <label class="block text-xs font-bold text-slate-400 uppercase tracking-widest mb-2">GÜNCEL TUTAR</label>
                    <div class="relative inline-block">
                        <input type="number" name="miktar" step="0.01" value="<?= $kayit['miktar'] ?>" required
                            class="w-full text-center text-5xl font-extrabold text-midnight bg-transparent border-b-2 border-slate-200 focus:border-midnight outline-none py-2 placeholder-slate-200 transition-colors font-mono"
                            style="max-width: 300px;">
                        <span class="absolute top-1/2 -right-8 -translate-y-1/2 text-2xl font-bold text-slate-400">₺</span>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="form-label text-xs uppercase text-slate-500">Açıklama</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fa-solid fa-pen text-slate-400 text-sm"></i>
                            </div>
                            <input type="text" name="aciklama" value="<?= htmlspecialchars($kayit['aciklama']) ?>" class="w-full pl-10 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:bg-white focus:border-sunburst focus:ring-2 focus:ring-sunburst/20 transition-all font-semibold text-midnight outline-none" required>
                        </div>
                    </div>

                    <div>
                        <label class="form-label text-xs uppercase text-slate-500">Kategori</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fa-solid fa-list text-slate-400 text-sm"></i>
                            </div>
                            <select name="kategori" id="kategoriSecimi" class="w-full pl-10 pr-8 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:bg-white focus:border-sunburst focus:ring-2 focus:ring-sunburst/20 transition-all font-semibold text-midnight outline-none appearance-none cursor-pointer">
                                </select>
                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                <i class="fa-solid fa-chevron-down text-xs text-slate-400"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <button type="submit" name="guncelle" class="w-full bg-sunburst hover:bg-sunburstHover text-midnight font-bold py-4 rounded-xl shadow-lg shadow-amber-500/30 transition-all transform hover:-translate-y-1 active:translate-y-0 flex items-center justify-center gap-3">
                    <span class="text-lg">Değişiklikleri Kaydet</span>
                    <i class="fa-solid fa-floppy-disk text-xl"></i>
                </button>

            </div>
        </form>
    </div>
    
    <div class="text-center mt-6">
        <a href="liste.php" class="text-slate-400 hover:text-slate-600 text-sm font-semibold transition-colors">
            Vazgeç ve Listeye Dön
        </a>
    </div>
</div>

<script>
// Dinamik Kategoriler
const giderKategorileri = <?= json_encode($jsGiderler) ?>;
const gelirKategorileri = <?= json_encode($jsGelirler) ?>;

// Mevcut değerler
const mevcutKategori = "<?= $kayit['kategori'] ?>";
const mevcutTur = "<?= $kayit['tur'] ?>";

function turDegisti(tur) {
    const select = document.getElementById("kategoriSecimi");
    const liste = (tur === 'gider') ? giderKategorileri : gelirKategorileri;
    
    select.innerHTML = "";
    
    // Listeyi doldur
    if(liste.length === 0) {
        const opt = document.createElement("option");
        opt.text = "Kategori Yok";
        select.appendChild(opt);
    } else {
        let bulundu = false;
        liste.forEach(kat => {
            const opt = document.createElement("option");
            opt.value = kat;
            opt.textContent = kat;
            
            // Eğer veritabanındaki kategori bu ise seçili yap
            if(kat === mevcutKategori) {
                opt.selected = true;
                bulundu = true;
            }
            select.appendChild(opt);
        });

        // Eğer eski kategori silinmişse ve listede yoksa, manuel ekle ki boş görünmesin
        if(!bulundu && mevcutTur === tur) {
            const opt = document.createElement("option");
            opt.value = mevcutKategori;
            opt.textContent = mevcutKategori + " (Arşivlenmiş)";
            opt.selected = true;
            select.appendChild(opt);
        }
    }
}

// Başlangıçta çalıştır
window.onload = () => turDegisti(mevcutTur);
</script>

<div style="height: 50px;"></div>
</body>
</html>