<?php
include 'db.php';

// Oturum kontrolü
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$user_id = $_SESSION['user_id'];

// Dosya ismini oluştur (Örn: harcamalar_2025-10-25.csv)
$filename = "harcamalar_" . date('Y-m-d') . ".csv";

// CSV Headerlarını ayarla (Tarayıcıya "Bu bir dosyadır, indir" der)
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=' . $filename);

// Çıktı kanalını aç
$output = fopen('php://output', 'w');

// Türkçe karakter sorunu olmaması için BOM (Byte Order Mark) ekle
fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

// Sütun Başlıklarını Yaz
fputcsv($output, array('ID', 'Tarih', 'Kategori', 'Açıklama', 'Tür', 'Tutar'));

// Verileri Çek
$sorgu = $db->prepare("SELECT * FROM islemler WHERE user_id = ? ORDER BY tarih DESC");
$sorgu->execute([$user_id]);
$satirlar = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Satırları döngüye al ve yaz
foreach ($satirlar as $satir) {
    fputcsv($output, array(
        $satir['id'],
        $satir['tarih'],
        $satir['kategori'],
        $satir['aciklama'],
        $satir['tur'], // 'gelir' veya 'gider'
        $satir['miktar']
    ));
}

fclose($output);
exit;
?>