<?php
include 'db.php';

// Güvenlik: Giriş yapmayan işlem yapamaz
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id']; // Giriş yapanın ID'si

// 1. EKLEME İŞLEMİ
if (isset($_POST['kaydet'])) {
    $aciklama = $_POST['aciklama'];
    $miktar = $_POST['miktar'];
    $tur = $_POST['tur'];
    $kategori = $_POST['kategori']; // Yeni gelen veri

    if($aciklama && $miktar) {
        // SQL Sorgusuna "kategori" alanını ekledik
        $sql = $db->prepare("INSERT INTO islemler (aciklama, miktar, tur, kategori, user_id) VALUES (?, ?, ?, ?, ?)");
        $sql->execute([$aciklama, $miktar, $tur, $kategori, $user_id]);
        
        header("Location: dashboard.php");
    } else {
        header("Location: ekle.php?hata=bos");
    }
}

// 2. SİLME İŞLEMİ (GÜVENLİ)
if (isset($_GET['sil'])) {
    $id = $_GET['sil'];
    
    // DİKKAT: "AND user_id = ?" diyerek sadece kendi verisini silmesini sağladık.
    $sql = $db->prepare("DELETE FROM islemler WHERE id = ? AND user_id = ?");
    $sql->execute([$id, $user_id]);
    
    header("Location: liste.php");
}
// 3. GÜNCELLEME İŞLEMİ
if (isset($_POST['guncelle'])) {
    $id = $_POST['id'];
    $aciklama = $_POST['aciklama'];
    $miktar = $_POST['miktar'];
    $tur = $_POST['tur'];
    $kategori = $_POST['kategori'];

    // Güvenlik: WHERE kısmında user_id mutlaka olmalı!
    // Yoksa URL'den ID değiştirip başkasının verisini güncellerler.
    $sql = $db->prepare("UPDATE islemler SET aciklama=?, miktar=?, tur=?, kategori=? WHERE id=? AND user_id=?");
    $kontrol = $sql->execute([$aciklama, $miktar, $tur, $kategori, $id, $user_id]);

    if ($kontrol) {
        header("Location: liste.php?mesaj=guncellendi");
    } else {
        echo "Bir hata oluştu.";
    }
}
?>