<?php 
include 'db.php';

// Oturum kontrolü
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit; }
$user_id = $_SESSION['user_id'];

// --- İŞLEMLER ---

// 1. EKLEME
if (isset($_POST['kategori_ekle'])) {
    $ad = trim($_POST['ad']);
    $tur = $_POST['tur'];
    
    if(!empty($ad)) {
        // Renk sütunu sorgudan çıkarıldı
        $db->prepare("INSERT INTO kategoriler (user_id, ad, tur) VALUES (?, ?, ?)")->execute([$user_id, $ad, $tur]);
        header("Location: kategoriler.php?durum=ok"); exit;
    }
}

// 2. SİLME
if (isset($_GET['sil'])) {
    $db->prepare("DELETE FROM kategoriler WHERE id = ? AND user_id = ?")->execute([$_GET['sil'], $user_id]);
    header("Location: kategoriler.php?durum=silindi"); exit;
}

// 3. DÜZENLEME
if (isset($_POST['kategori_guncelle'])) {
    $id = $_POST['edit_id'];
    $ad = trim($_POST['edit_ad']);
    $tur = $_POST['edit_tur'];
    
    if(!empty($ad)) {
        // Renk güncellemesi çıkarıldı
        $sql = $db->prepare("UPDATE kategoriler SET ad = ?, tur = ? WHERE id = ? AND user_id = ?");
        $sql->execute([$ad, $tur, $id, $user_id]);
        header("Location: kategoriler.php?durum=guncellendi"); exit;
    }
}

include 'header.php'; 

// Kategorileri Çek
$sorgu = $db->prepare("SELECT * FROM kategoriler WHERE user_id = ? ORDER BY ad ASC");
$sorgu->execute([$user_id]);
$tumKategoriler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

$gelirKategorileri = [];
$giderKategorileri = [];
foreach($tumKategoriler as $kat) {
    if($kat['tur'] == 'gelir') $gelirKategorileri[] = $kat; else $giderKategorileri[] = $kat;
}
?>

<div class="max-w-6xl mx-auto">
    <div class="mb-8 flex flex-col md:flex-row justify-between items-end gap-4">
        <div>
            <h1 class="text-3xl font-bold text-midnight mb-2">Kategori Yönetimi</h1>
            <p class="text-slate-500 font-medium">Gelir ve gider kalemlerini yönet.</p>
        </div>
        <button onclick="document.getElementById('eklemeFormu').scrollIntoView({behavior: 'smooth'})" class="lg:hidden bg-midnight text-white px-4 py-2 rounded-lg text-sm font-bold"><i class="fa-solid fa-plus"></i> Yeni Ekle</button>
    </div>

    <?php if(isset($_GET['durum'])): ?>
        <div class="mb-6 p-4 rounded-xl border flex items-center gap-3 shadow-sm font-bold 
            <?= ($_GET['durum']=='silindi') ? 'bg-red-50 text-red-700 border-red-100' : 'bg-emerald-50 text-emerald-700 border-emerald-100' ?>">
            <i class="fa-solid <?= ($_GET['durum']=='silindi') ? 'fa-trash' : 'fa-check-circle' ?> text-xl"></i>
            <span>
                <?= ($_GET['durum']=='ok') ? 'Kategori başarıyla eklendi.' : (($_GET['durum']=='silindi') ? 'Kategori silindi.' : 'Kategori güncellendi.') ?>
            </span>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        
        <div class="lg:col-span-1">
            <div id="eklemeFormu" class="card-panel sticky top-6 border-t-4 border-t-midnight shadow-2xl">
                <h3 class="text-lg font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-circle-plus text-sunburst"></i> Yeni Oluştur</h3>
                
                <form method="POST">
                    <div class="mb-5">
                        <label class="text-xs font-bold text-slate-500 uppercase mb-1 block">Kategori İsmi</label>
                        <div class="relative"><i class="fa-solid fa-tag absolute left-3 top-3.5 text-slate-400 text-sm"></i><input type="text" name="ad" class="form-input pl-10 font-semibold" placeholder="Örn: Market" required autocomplete="off"></div>
                    </div>
                    
                    <div class="mb-8">
                        <label class="text-xs font-bold text-slate-500 uppercase mb-1 block">Tür</label>
                        <div class="grid grid-cols-2 gap-3">
                            <label class="cursor-pointer"><input type="radio" name="tur" value="gider" class="peer sr-only" checked><div class="text-center py-3 rounded-xl border border-slate-200 text-slate-500 peer-checked:bg-red-50 peer-checked:text-red-600 peer-checked:border-red-200 transition-all font-bold text-sm hover:bg-slate-50"><i class="fa-solid fa-arrow-trend-down mr-1"></i> GİDER</div></label>
                            <label class="cursor-pointer"><input type="radio" name="tur" value="gelir" class="peer sr-only"><div class="text-center py-3 rounded-xl border border-slate-200 text-slate-500 peer-checked:bg-emerald-50 peer-checked:text-emerald-600 peer-checked:border-emerald-200 transition-all font-bold text-sm hover:bg-slate-50"><i class="fa-solid fa-arrow-trend-up mr-1"></i> GELİR</div></label>
                        </div>
                    </div>
                    <button type="submit" name="kategori_ekle" class="btn-primary w-full justify-center py-3.5 shadow-lg shadow-amber-500/20"><i class="fa-solid fa-check"></i> Ekle</button>
                </form>
            </div>
        </div>

        <div class="lg:col-span-2 space-y-8">
            
            <div class="card-panel p-0 overflow-hidden border-0 shadow-xl bg-white">
                <div class="p-5 border-b border-red-100 bg-red-50/50 flex justify-between items-center">
                    <h3 class="font-bold text-red-700 flex items-center gap-2"><div class="w-8 h-8 rounded-lg bg-red-100 flex items-center justify-center"><i class="fa-solid fa-arrow-trend-down"></i></div> Gider Kategorileri</h3>
                    <span class="text-xs font-bold bg-white text-red-600 px-3 py-1 rounded-full border border-red-100"><?= count($giderKategorileri) ?></span>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-px bg-slate-100 border-t border-slate-100">
                    <?php foreach($giderKategorileri as $kat): ?>
                    <div class="bg-white p-4 flex items-center justify-between group hover:bg-slate-50 transition-colors">
                        <div class="flex items-center gap-3">
                            <i class="fa-solid fa-circle text-[6px] text-red-400"></i>
                            <span class="font-bold text-slate-700"><?= htmlspecialchars($kat['ad']) ?></span>
                        </div>
                        <div class="flex gap-1">
                            <button onclick="duzenleModalAc(<?= $kat['id'] ?>, '<?= htmlspecialchars($kat['ad']) ?>', '<?= $kat['tur'] ?>')" class="w-8 h-8 flex items-center justify-center rounded-lg text-slate-300 hover:text-blue-500 hover:bg-blue-50 transition-colors"><i class="fa-solid fa-pen"></i></button>
                            <button onclick="silModalAc(<?= $kat['id'] ?>)" class="w-8 h-8 flex items-center justify-center rounded-lg text-slate-300 hover:text-red-500 hover:bg-red-50 transition-colors"><i class="fa-solid fa-trash-can"></i></button>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    <?php if(empty($giderKategorileri)): ?><div class="bg-white col-span-2 p-8 text-center text-slate-400">Gider kategorisi yok.</div><?php endif; ?>
                </div>
            </div>

            <div class="card-panel p-0 overflow-hidden border-0 shadow-xl bg-white">
                <div class="p-5 border-b border-emerald-100 bg-emerald-50/50 flex justify-between items-center">
                    <h3 class="font-bold text-emerald-700 flex items-center gap-2"><div class="w-8 h-8 rounded-lg bg-emerald-100 flex items-center justify-center"><i class="fa-solid fa-arrow-trend-up"></i></div> Gelir Kategorileri</h3>
                    <span class="text-xs font-bold bg-white text-emerald-600 px-3 py-1 rounded-full border border-emerald-100"><?= count($gelirKategorileri) ?></span>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-px bg-slate-100 border-t border-slate-100">
                    <?php foreach($gelirKategorileri as $kat): ?>
                    <div class="bg-white p-4 flex items-center justify-between group hover:bg-slate-50 transition-colors">
                        <div class="flex items-center gap-3">
                            <i class="fa-solid fa-circle text-[6px] text-emerald-400"></i>
                            <span class="font-bold text-slate-700"><?= htmlspecialchars($kat['ad']) ?></span>
                        </div>
                        <div class="flex gap-1">
                            <button onclick="duzenleModalAc(<?= $kat['id'] ?>, '<?= htmlspecialchars($kat['ad']) ?>', '<?= $kat['tur'] ?>')" class="w-8 h-8 flex items-center justify-center rounded-lg text-slate-300 hover:text-blue-500 hover:bg-blue-50 transition-colors"><i class="fa-solid fa-pen"></i></button>
                            <button onclick="silModalAc(<?= $kat['id'] ?>)" class="w-8 h-8 flex items-center justify-center rounded-lg text-slate-300 hover:text-red-500 hover:bg-red-50 transition-colors"><i class="fa-solid fa-trash-can"></i></button>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    <?php if(empty($gelirKategorileri)): ?><div class="bg-white col-span-2 p-8 text-center text-slate-400">Gelir kategorisi yok.</div><?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="silmeModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-sm shadow-2xl relative transform scale-100 transition-all">
        <div class="w-16 h-16 rounded-full bg-red-100 text-red-600 flex items-center justify-center mx-auto mb-4 border-4 border-red-50"><i class="fa-solid fa-trash-can text-2xl"></i></div>
        <h3 class="text-xl font-bold text-center text-midnight mb-2">Kategoriyi Sil?</h3>
        <p class="text-slate-500 text-center text-sm mb-6">Bu işlem geri alınamaz.</p>
        <div class="grid grid-cols-2 gap-3">
            <button onclick="modalKapat('silmeModal')" class="py-3 rounded-xl border border-slate-200 text-slate-600 font-bold hover:bg-slate-50 transition-colors">Vazgeç</button>
            <a id="silmeLink" href="#" class="py-3 rounded-xl bg-red-600 text-white font-bold text-center hover:bg-red-700 shadow-lg shadow-red-500/30">Sil</a>
        </div>
    </div>
</div>

<div id="duzenleModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-sm shadow-2xl relative transform scale-100 transition-all">
        <h3 class="text-xl font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-pen text-sunburst"></i> Düzenle</h3>
        <form method="POST">
            <input type="hidden" name="edit_id" id="edit_id">
            
            <div class="mb-5">
                <label class="text-xs font-bold text-slate-500 uppercase mb-1 block">Kategori Adı</label>
                <input type="text" name="edit_ad" id="edit_ad" class="form-input font-bold" required>
            </div>

            <div class="mb-8">
                <label class="text-xs font-bold text-slate-500 uppercase mb-1 block">Tür</label>
                <select name="edit_tur" id="edit_tur" class="form-select font-bold">
                    <option value="gider">Gider</option>
                    <option value="gelir">Gelir</option>
                </select>
            </div>
            
            <div class="grid grid-cols-2 gap-3">
                <button type="button" onclick="modalKapat('duzenleModal')" class="py-3 rounded-xl border border-slate-200 text-slate-600 font-bold hover:bg-slate-50">İptal</button>
                <button type="submit" name="kategori_guncelle" class="py-3 rounded-xl bg-midnight text-white font-bold hover:bg-slate-800 shadow-lg">Güncelle</button>
            </div>
        </form>
    </div>
</div>

<script>
    function silModalAc(id) {
        document.getElementById('silmeModal').classList.remove('hidden');
        document.getElementById('silmeLink').href = "?sil=" + id;
    }

    function duzenleModalAc(id, ad, tur) {
        document.getElementById('duzenleModal').classList.remove('hidden');
        document.getElementById('edit_id').value = id;
        document.getElementById('edit_ad').value = ad;
        document.getElementById('edit_tur').value = tur;
    }

    function modalKapat(id) { document.getElementById(id).classList.add('hidden'); }
    
    window.onclick = function(event) {
        if (event.target.classList.contains('fixed')) {
            event.target.classList.add('hidden');
        }
    }
</script>

<div class="h-12"></div>
</body>
</html>