<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];
    $bugun = date("Y-m-d");

    // Günü gelenleri bul
    $sorgu = $db->prepare("SELECT * FROM abonelikler WHERE user_id = ? AND sonraki_tarih <= ?");
    $sorgu->execute([$user_id, $bugun]);
    $abonelikler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

    foreach ($abonelikler as $abone) {
        $yeniTarih = $abone['sonraki_tarih'];
        $periyot = $abone['periyot']; // gunluk, haftalik, aylik, yillik

        // Tarih atlatma mantığı
        $artisMiktari = "+1 month"; // Varsayılan
        if ($periyot == 'gunluk') $artisMiktari = "+1 day";
        elseif ($periyot == 'haftalik') $artisMiktari = "+1 week";
        elseif ($periyot == 'yillik') $artisMiktari = "+1 year";

        // Kullanıcı uzun süre girmezse aradaki tüm dönemleri ekle
        while ($yeniTarih <= $bugun) {
            
            // 1. İşlemi Ekle
            $ekle = $db->prepare("INSERT INTO islemler (user_id, aciklama, miktar, tur, kategori, tarih) VALUES (?, ?, ?, ?, ?, ?)");
            $ekle->execute([$user_id, $abone['baslik'], $abone['miktar'], $abone['tur'], $abone['kategori'], $yeniTarih]);

            // 2. Tarihi İleri Al
            $yeniTarih = date("Y-m-d", strtotime($artisMiktari, strtotime($yeniTarih)));
        }

        // 3. Aboneliği Güncelle
        $guncelle = $db->prepare("UPDATE abonelikler SET sonraki_tarih = ? WHERE id = ?");
        $guncelle->execute([$yeniTarih, $abone['id']]);
    }
}
?>