<?php 
include 'db.php';
include 'header.php'; 

$user_id = $_SESSION['user_id'];

// FİLTRELEME
$bas_tarih = $_GET['bas'] ?? '';
$bit_tarih = $_GET['bit'] ?? '';
$tarihKosulu = "";
$baslik = "Genel Rapor";

if (!empty($bas_tarih) && !empty($bit_tarih)) {
    $tarihKosulu = " AND DATE(tarih) BETWEEN '$bas_tarih' AND '$bit_tarih'";
    $baslik = date("d.m.Y", strtotime($bas_tarih)) . " - " . date("d.m.Y", strtotime($bit_tarih));
}

// VERİ ÇEKME
$sql = $db->prepare("SELECT kategori, tur, SUM(miktar) as toplam, COUNT(*) as adet FROM islemler WHERE user_id = ? $tarihKosulu GROUP BY kategori, tur ORDER BY toplam DESC");
$sql->execute([$user_id]);
$veriler = $sql->fetchAll(PDO::FETCH_ASSOC);

$toplamHacim = 0;
$toplamAdet = 0;
$etiketler = [];
$rakamlar = [];
$renkler = [];

foreach($veriler as $v) {
    $toplamHacim += $v['toplam'];
    $toplamAdet += $v['adet'];
    $etiketler[] = $v['kategori'];
    $rakamlar[] = $v['toplam'];
    $renkler[] = ($v['tur'] == 'gelir') ? '#10b981' : '#f43f5e';
}
?>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div class="max-w-7xl mx-auto">

    <div class="flex flex-col lg:flex-row lg:items-end justify-between gap-6 mb-8">
        <div>
            <h1 class="text-3xl font-bold text-midnight mb-1"><?= $baslik ?></h1>
            <p class="text-slate-500 font-medium">Harcama ve gelir analizi.</p>
        </div>
        
        <form method="GET" class="bg-white p-2 rounded-xl border border-slate-200 shadow-sm flex items-center gap-2">
            <input type="date" name="bas" value="<?= $bas_tarih ?>" class="form-input py-2 text-sm w-auto" required>
            <span class="text-slate-400">-</span>
            <input type="date" name="bit" value="<?= $bit_tarih ?>" class="form-input py-2 text-sm w-auto" required>
            <button type="submit" class="bg-midnight text-white px-4 py-2 rounded-lg text-sm font-bold hover:bg-slate-800 transition-colors">Uygula</button>
            <?php if(!empty($bas_tarih)): ?>
                <a href="rapor.php" class="text-slate-400 hover:text-red-500 px-2"><i class="fa-solid fa-xmark"></i></a>
            <?php endif; ?>
        </form>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
        <div class="card-panel p-6 flex items-center gap-5 border-l-4 border-l-sunburst">
            <div class="w-14 h-14 rounded-2xl bg-amber-50 text-sunburst flex items-center justify-center text-2xl shadow-sm"><i class="fa-solid fa-coins"></i></div>
            <div><div class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">TOPLAM İŞLEM HACMİ</div><div class="text-2xl font-extrabold text-midnight font-mono"><?= number_format($toplamHacim, 2) ?> ₺</div></div>
        </div>
        <div class="card-panel p-6 flex items-center gap-5 border-l-4 border-l-indigo-500">
            <div class="w-14 h-14 rounded-2xl bg-indigo-50 text-indigo-500 flex items-center justify-center text-2xl shadow-sm"><i class="fa-solid fa-receipt"></i></div>
            <div><div class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">TOPLAM İŞLEM SAYISI</div><div class="text-2xl font-extrabold text-midnight"><?= $toplamAdet ?> <span class="text-sm font-medium text-slate-400">Adet</span></div></div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <div class="lg:col-span-1 card-panel h-full flex flex-col relative overflow-hidden bg-white">
            <h3 class="font-bold text-midnight mb-6">Dağılım Grafiği</h3>
            <div class="relative w-full h-72 flex items-center justify-center">
                <?php if($toplamHacim > 0): ?><canvas id="anaChart"></canvas><?php else: ?><div class="text-center text-slate-400 opacity-60"><i class="fa-solid fa-chart-pie text-5xl mb-3"></i><p class="text-sm">Veri yok</p></div><?php endif; ?>
            </div>
        </div>

        <div class="lg:col-span-2 card-panel p-0 overflow-hidden border-0 shadow-xl bg-white">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead><tr class="bg-white border-b border-slate-100 text-xs uppercase tracking-wider text-slate-400 font-bold"><th class="px-6 py-4">Kategori</th><th class="px-6 py-4 w-2/5">Pay</th><th class="px-6 py-4 text-right">Tutar</th></tr></thead>
                    <tbody class="divide-y divide-slate-50">
                        <?php foreach($veriler as $v): 
                            $yuzde = ($toplamHacim > 0) ? round(($v['toplam'] / $toplamHacim) * 100) : 0;
                            $renk = ($v['tur'] == 'gelir') ? 'bg-emerald-500' : 'bg-rose-500';
                            $textRenk = ($v['tur'] == 'gelir') ? 'text-emerald-600' : 'text-rose-600';
                        ?>
                        <tr class="hover:bg-slate-50 transition-colors">
                            <td class="px-6 py-4 font-bold text-slate-700"><?= htmlspecialchars($v['kategori']) ?> <span class="text-xs font-normal text-slate-400 ml-2">(<?= $v['adet'] ?>)</span></td>
                            <td class="px-6 py-4"><div class="flex items-center gap-3"><span class="text-xs font-bold text-slate-500 w-8 text-right">%<?= $yuzde ?></span><div class="flex-1 h-2 bg-slate-100 rounded-full overflow-hidden"><div class="h-full <?= $renk ?> rounded-full" style="width: <?= $yuzde ?>%"></div></div></div></td>
                            <td class="px-6 py-4 text-right font-mono font-bold <?= $textRenk ?>"><?= number_format($v['toplam'], 2) ?> ₺</td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if(empty($veriler)): ?><tr><td colspan="3" class="px-6 py-12 text-center text-slate-400">Veri bulunamadı.</td></tr><?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    const ctx = document.getElementById('anaChart');
    if(ctx) {
        Chart.defaults.font.family = "'Plus Jakarta Sans', sans-serif";
        new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: <?= json_encode($etiketler) ?>,
                datasets: [{ data: <?= json_encode($rakamlar) ?>, backgroundColor: <?= json_encode($renkler) ?>, borderWidth: 0, hoverOffset: 15 }]
            },
            options: { responsive: true, maintainAspectRatio: false, cutout: '65%', plugins: { legend: { position: 'bottom', labels: { usePointStyle: true, padding: 20, font: { size: 11, weight: '700' } } } } }
        });
    }
</script>
<div class="h-12"></div>
</main></div></body></html>