<?php
include 'db.php';

if(isset($_SESSION['user_id'])){
    header("Location: dashboard.php");
    exit;
}

if (isset($_POST['kayit_ol'])) {
    $ad = $_POST['ad'];
    $email = $_POST['email'];
    $sifre = password_hash($_POST['sifre'], PASSWORD_DEFAULT);

    $kontrol = $db->prepare("SELECT * FROM kullanicilar WHERE email = ?");
    $kontrol->execute([$email]);

    if ($kontrol->rowCount() > 0) {
        $hata = "Bu e-posta zaten kullanımda.";
    } else {
        $sql = $db->prepare("INSERT INTO kullanicilar (ad_soyad, email, sifre) VALUES (?,?,?)");
        if ($sql->execute([$ad, $email, $sifre])) {
            $_SESSION['user_id'] = $db->lastInsertId();
            $_SESSION['ad_soyad'] = $ad;
            header("Location: dashboard.php");
            exit;
        } else {
            $hata = "Kayıt oluşturulamadı.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kayıt Ol - Monify</title>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['"Plus Jakarta Sans"', 'sans-serif'] },
                    colors: {
                        midnight: '#0f172a',
                        sunburst: '#f59e0b',
                        sunburstHover: '#d97706',
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-slate-50 min-h-screen flex items-center justify-center p-4">

    <div class="w-full max-w-5xl bg-white rounded-3xl shadow-2xl overflow-hidden flex flex-col md:flex-row h-[600px]">
        
        <div class="md:w-1/2 bg-midnight relative flex flex-col items-center justify-center p-10 text-center text-white overflow-hidden">
            <div class="absolute top-0 right-0 w-64 h-64 bg-sunburst/10 rounded-full blur-3xl -mt-10 -mr-10"></div>
            <div class="absolute bottom-0 left-0 w-64 h-64 bg-emerald-500/20 rounded-full blur-3xl -mb-10 -ml-10"></div>
            
            <div class="relative z-10">
                <div class="w-20 h-20 bg-gradient-to-br from-emerald-400 to-emerald-600 rounded-2xl flex items-center justify-center text-3xl shadow-lg mb-6 mx-auto">
                    <i class="fa-solid fa-rocket text-white"></i>
                </div>
                <h2 class="text-3xl font-extrabold mb-4">Hemen Başla.</h2>
                <p class="text-slate-400 text-sm leading-relaxed max-w-xs mx-auto">
                    30 saniyede hesabını oluştur, finansal hedeflerine bir adım daha yaklaş.
                </p>
            </div>
            <div class="mt-12 text-xs text-slate-500">© 2025 Monify App</div>
        </div>

        <div class="md:w-1/2 p-8 md:p-12 flex flex-col justify-center relative">
            <div class="max-w-sm mx-auto w-full">
                <h1 class="text-2xl font-bold text-midnight mb-2">Hesap Oluştur</h1>
                <p class="text-slate-500 text-sm mb-6">Tamamen ücretsiz ve güvenli.</p>

                <?php if(isset($hata)): ?>
                    <div class="mb-6 p-4 rounded-xl bg-red-50 text-red-600 text-sm font-bold flex items-center gap-3 border border-red-100">
                        <i class="fa-solid fa-circle-exclamation"></i> <?= $hata ?>
                    </div>
                <?php endif; ?>

                <form method="POST" class="space-y-4">
                    <div>
                        <label class="block text-xs font-bold text-slate-700 uppercase mb-1">Ad Soyad</label>
                        <input type="text" name="ad" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:bg-white focus:border-sunburst focus:ring-2 focus:ring-sunburst/20 transition-all outline-none font-semibold text-midnight" placeholder="Adınız" required>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-slate-700 uppercase mb-1">E-Posta</label>
                        <input type="email" name="email" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:bg-white focus:border-sunburst focus:ring-2 focus:ring-sunburst/20 transition-all outline-none font-semibold text-midnight" placeholder="mail@ornek.com" required>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-slate-700 uppercase mb-1">Şifre</label>
                        <input type="password" name="sifre" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:bg-white focus:border-sunburst focus:ring-2 focus:ring-sunburst/20 transition-all outline-none font-semibold text-midnight" placeholder="En az 6 karakter" required>
                    </div>

                    <button type="submit" name="kayit_ol" class="w-full bg-midnight hover:bg-slate-800 text-white font-bold py-3.5 rounded-xl shadow-lg shadow-midnight/20 transition-all transform hover:-translate-y-1 mt-2">
                        Kayıt Ol
                    </button>
                </form>

                <div class="mt-6 text-center text-sm">
                    <span class="text-slate-500">Zaten üye misin?</span>
                    <a href="login.php" class="text-sunburst font-bold hover:text-sunburstHover ml-1">Giriş Yap</a>
                </div>
            </div>
        </div>

    </div>

</body>
</html>