<?php 
// Veritabanı bağlantısını dahil ediyoruz
include 'includes/db.php'; 
include 'includes/header.php'; 
// Son eklenen 4 projeyi çekiyoruz
$sorgu = "SELECT * FROM projects ORDER BY id DESC LIMIT 4";
$projeler = $conn->query($sorgu);
?>
<main class="max-w-6xl mx-auto px-6 pt-24 pb-32 flex flex-col lg:flex-row gap-16 justify-center">
    

    <section class="max-w-2xl w-full">
       
<main class="max-w-3xl mx-auto px-6 pt-24 pb-32">
    <section class="mb-20">
        <div class="flex items-center gap-4 mb-6">
            <img src="assets/img/ben.jpg" alt="Profil" class="w-16 h-16 rounded-full grayscale hover:grayscale-0 transition-all duration-500 border-2 border-white shadow-sm">
            <span class="px-3 py-1 bg-green-50 text-green-600 text-xs font-medium rounded-full ring-1 ring-green-100 italic">
                Şu an yeni projeler üzerine çalışıyorum...
            </span>
        </div>
        
        <h1 class="text-4xl font-semibold tracking-tight text-gray-900 mb-6">
            Merhaba, ben Burak. <br>Kodla hikayeler yazmayı seviyorum.
        </h1>
        
        <p class="text-lg text-gray-600 leading-relaxed">
            Burada kendi halimde PHP scriptleri geliştiriyor ve <span class="text-black font-medium border-b border-gray-200">ücretsiz</span> olarak paylaşıyorum. Tasarımda sadeliği, kodda ise dürüstlüğü savunuyorum.
        </p>
    </section>

    <section class="mb-20">
        <div class="flex justify-between items-end mb-8">
            <h2 class="text-xl font-medium text-gray-900">Neler Ürettim?</h2>
            <a href="projeler.php" class="text-sm text-gray-400 hover:text-black transition">Tümünü gör</a>
        </div>

        <div class="space-y-4">
            <?php if ($projeler->num_rows > 0): ?>
                <?php while($proje = $projeler->fetch_assoc()): ?>
                <a href="<?php echo $proje['link']; ?>" target="_blank" class="group flex items-center justify-between p-4 rounded-xl hover:bg-white hover:shadow-xl hover:shadow-gray-200/50 transition-all duration-300 border border-transparent hover:border-gray-100">
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center group-hover:bg-black group-hover:text-white transition-colors">
                            <span class="text-xs font-mono uppercase"><?php echo substr($proje['title'], 0, 2); ?></span>
                        </div>
                        <div>
                            <h3 class="text-md font-medium text-gray-900"><?php echo $proje['title']; ?></h3>
                            <p class="text-sm text-gray-400"><?php echo $proje['tags']; ?></p>
                        </div>
                    </div>
                    <span class="text-xs font-medium px-2 py-1 bg-gray-50 rounded text-gray-400 group-hover:bg-green-50 group-hover:text-green-600 transition-colors uppercase">
                        İncele
                    </span>
                </a>
                <?php endwhile; ?>
            <?php else: ?>
                <p class="text-gray-400 italic text-sm text-center py-10">Henüz buraya bir şey eklemedim ama çok yakında harika scriptler gelecek.</p>
            <?php endif; ?>
        </div>
    </section>

    <section class="p-8 bg-gray-50 rounded-2xl border border-gray-100">
        <h3 class="text-lg font-medium mb-2">Bana her zaman ulaşabilirsin.</h3>
        <p class="text-gray-500 text-sm mb-6">Ego yok, karmaşa yok. Sadece bir mesaj uzağındayım.</p>
        <a href="https://wa.me/908503023459" class="inline-flex items-center text-black font-semibold hover:gap-2 transition-all">
            0850 302 34 59 <span class="ml-2">→</span>
        </a>
    </section>
    
</main>

<?php include 'includes/footer.php'; ?>