<nav class="bg-white/80 backdrop-blur-xl border-b border-slate-100 sticky top-0 z-50">
    <div class="max-w-7xl mx-auto px-6">
        <div class="flex flex-col md:flex-row md:h-20 py-4 md:py-0 justify-between items-center gap-4">
            
            <div class="flex items-center justify-between w-full md:w-auto">
                <a href="index.php" class="flex items-center shrink-0">
                    <?php if(!empty($settings['site_logo'])): ?>
                        <img src="assets/<?php echo $settings['site_logo']; ?>" class="h-7 w-auto">
                    <?php else: ?>
                        <span class="text-2xl font-black tracking-tighter uppercase italic">BLOG<span class="text-indigo-600">.</span>PRO</span>
                    <?php endif; ?>
                </a>
                
                <a href="kategori.php" class="md:hidden text-[10px] font-bold uppercase tracking-widest text-slate-400">Kategoriler</a>
            </div>

            <div class="flex items-center w-full md:w-auto gap-4">
                <form action="arama.php" method="GET" class="relative flex-1 md:flex-none">
                    <input type="text" name="q" value="<?php echo isset($_GET['q']) ? htmlspecialchars($_GET['q']) : ''; ?>" placeholder="İçeriklerde ara..." 
                           class="w-full md:w-64 bg-slate-100 border-none rounded-xl px-5 py-2.5 text-xs font-bold outline-none focus:ring-2 focus:ring-black transition-all">
                    <button type="submit" class="absolute right-4 top-2.5 text-slate-400">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                    </button>
                </form>
                
                <div class="hidden md:flex gap-8 text-[11px] font-black uppercase tracking-widest text-slate-400">
                    <a href="index.php" class="hover:text-black transition">Anasayfa</a>
                    <a href="kategori.php" class="hover:text-black transition">Kategoriler</a>
                </div>
            </div>

        </div>
    </div>
</nav>