<?php 
require 'config.php'; 

$short_url = "";
if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['url'])) {
    $long_url = $_POST['url'];
    $short_code = substr(md5(uniqid()), 0, 6);
    
    $stmt = $pdo->prepare("INSERT INTO urls (long_url, short_code) VALUES (?, ?)");
    if ($stmt->execute([$long_url, $short_code])) {
        // BURAYI KENDİ URL YAPINA GÖRE DÜZENLE
        $short_url = "http://localhost/url_kisaltici/" . $short_code;
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Slink - Modern URL Management</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { 
            font-family: 'Inter', sans-serif;
            background-color: #f9fafb;
            background-image: radial-gradient(#e5e7eb 1px, transparent 1px);
            background-size: 20px 20px;
        }
        .main-card {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(8px);
        }
    </style>
</head>
<body class="min-h-screen flex flex-col items-center justify-center p-4">

    <div class="mb-12 text-center">
        <div class="flex items-center justify-center mb-4">
            <div class="bg-blue-600 p-2.5 rounded-xl shadow-lg shadow-blue-200">
                <i class="fas fa-bolt text-white text-xl"></i>
            </div>
            <span class="ml-3 text-2xl font-bold text-gray-900 tracking-tight">Slink<span class="text-blue-600">.io</span></span>
        </div>
        <h1 class="text-gray-500 text-lg font-medium">Linklerinizi profesyonelce yönetin ve takip edin.</h1>
    </div>

    <div class="w-full max-w-2xl">
        <div class="main-card border border-gray-200 shadow-[0_20px_50px_rgba(0,0,0,0.05)] rounded-[2rem] p-4 md:p-10">
            
            <form method="POST" class="relative">
                <div class="flex flex-col md:flex-row gap-3">
                    <div class="relative flex-grow">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-gray-400">
                            <i class="fas fa-link"></i>
                        </div>
                        <input type="url" name="url" required 
                            placeholder="Kısaltmak istediğiniz linki buraya bırakın..."
                            class="w-full pl-11 pr-4 py-4 bg-gray-50 border border-gray-200 rounded-2xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-gray-700 placeholder-gray-400">
                    </div>
                    <button type="submit" 
                        class="bg-gray-900 hover:bg-black text-white px-8 py-4 rounded-2xl font-semibold transition-all shadow-lg hover:shadow-xl active:scale-95">
                        Ücretsiz Kısalt
                    </button>
                </div>
            </form>

            <?php if ($short_url): ?>
            <div class="mt-10 animate-in fade-in slide-in-from-bottom-4 duration-500">
                <div class="p-6 bg-blue-50 border border-blue-100 rounded-3xl flex flex-col md:flex-row items-center justify-between gap-4">
                    <div class="flex items-center gap-4">
                        <div class="bg-white p-3 rounded-2xl shadow-sm border border-blue-100">
                            <i class="fas fa-check text-blue-600"></i>
                        </div>
                        <div>
                            <p class="text-sm text-blue-600 font-semibold uppercase tracking-wider">Linkiniz Hazır</p>
                            <a href="<?= $short_url ?>" id="shortUrl" target="_blank" class="text-gray-900 font-bold text-lg hover:underline"><?= $short_url ?></a>
                        </div>
                    </div>
                    <button onclick="copyToClipboard()" id="copyBtn"
                        class="w-full md:w-auto bg-white border border-blue-200 text-blue-600 px-6 py-3 rounded-xl font-bold hover:bg-blue-600 hover:text-white transition-all shadow-sm">
                        <i class="far fa-copy mr-2"></i> Kopyala
                    </button>
                </div>
            </div>
            <?php endif; ?>

            <div class="grid grid-cols-3 gap-6 mt-12 pt-8 border-t border-gray-100">
                <div class="text-center">
                    <p class="text-2xl font-bold text-gray-900">0ms</p>
                    <p class="text-xs text-gray-400 uppercase font-semibold mt-1">Gecikme</p>
                </div>
                <div class="text-center border-x border-gray-100">
                    <p class="text-2xl font-bold text-gray-900">∞</p>
                    <p class="text-xs text-gray-400 uppercase font-semibold mt-1">Sınırsız Link</p>
                </div>
                <div class="text-center">
                    <p class="text-2xl font-bold text-gray-900">Güvenli</p>
                    <p class="text-xs text-gray-400 uppercase font-semibold mt-1">SSL Şifreli</p>
                </div>
            </div>
        </div>

        <div class="mt-10 flex flex-col md:flex-row items-center justify-between text-gray-400 text-sm px-4">
            <p>&copy; 2026 Slink v2.0</p>
            <div class="flex gap-6 mt-4 md:mt-0">
               
        </div>
    </div>

    <script>
        function copyToClipboard() {
            const urlText = document.getElementById("shortUrl").innerText;
            const btn = document.getElementById("copyBtn");
            
            navigator.clipboard.writeText(urlText).then(() => {
                const originalHtml = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-check mr-2"></i> Kopyalandı';
                btn.classList.add('bg-blue-600', 'text-white');
                
                setTimeout(() => {
                    btn.innerHTML = originalHtml;
                    btn.classList.remove('bg-blue-600', 'text-white');
                }, 2000);
            });
        }
    </script>
</body>
</html>