<?php 
require_once 'auth.php'; 
require_once '../includes/db.php';
include 'includes/header.php'; 

// Mesajları çek
$messages = $db->query("SELECT * FROM messages ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="mb-12">
    <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-2 leading-none">Müşteri Talepleri</p>
    <h1 class="text-2xl font-bold text-slate-900 tracking-tight leading-none">Gelen Mesajlar</h1>
</div>

<div class="grid gap-6">
    <?php if(!empty($messages)): foreach($messages as $m): ?>
    <div class="bg-white border border-slate-100 rounded-[2rem] p-8 shadow-sm group hover:border-blue-100 transition-all">
        <div class="flex justify-between items-start mb-6">
            <div class="flex items-center gap-4">
                <div class="w-12 h-12 rounded-full bg-slate-50 flex items-center justify-center text-blue-600 font-bold text-lg">
                    <?php echo strtoupper(substr($m['name'], 0, 1)); ?>
                </div>
                <div>
                    <h4 class="text-sm font-bold text-slate-900"><?php echo htmlspecialchars($m['name']); ?></h4>
                    <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest"><?php echo htmlspecialchars($m['email']); ?></p>
                </div>
            </div>
            <span class="text-[9px] font-black uppercase tracking-widest text-slate-300"><?php echo $m['created_at']; ?></span>
        </div>
        
        <div class="pl-16">
            <p class="text-xs font-bold text-slate-900 mb-2 uppercase tracking-tight italic">"<?php echo htmlspecialchars($m['subject']); ?>"</p>
            <p class="text-sm text-slate-500 leading-relaxed"><?php echo nl2br(htmlspecialchars($m['message'])); ?></p>
        </div>
    </div>
    <?php endforeach; else: ?>
        <p class="text-slate-400 italic text-center py-20">Henüz gelen bir mesaj bulunmuyor.</p>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>