<?php 
require_once 'auth.php'; 
require_once '../includes/db.php';
include 'includes/header.php'; 
?>

<div class="mb-10">
    <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-2 leading-none">İçerik Ekleme</p>
    <h1 class="text-2xl font-bold text-slate-900 tracking-tight leading-none">Yeni Hizmet Oluştur</h1>
</div>

<form action="process.php?action=add_service" method="POST" enctype="multipart/form-data" class="space-y-6 max-w-4xl pb-20">
    
    <div class="bg-white p-8 rounded-[2rem] border border-slate-100 shadow-sm space-y-6">
        <h3 class="text-[10px] font-bold text-slate-400 uppercase tracking-widest border-b border-slate-50 pb-4">Temel Detaylar</h3>
        <div class="grid md:grid-cols-2 gap-6">
            <div class="space-y-2">
                <label class="text-[10px] font-bold text-slate-500 uppercase tracking-widest ml-1">Hizmet Başlığı</label>
                <input type="text" name="title" required placeholder="Örn: Profesyonel Web Tasarımı" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 focus:border-blue-600 outline-none transition-all text-sm font-semibold">
            </div>
            <div class="space-y-2">
                <label class="text-[10px] font-bold text-slate-500 uppercase tracking-widest ml-1">Görüntüleme Sırası</label>
                <input type="number" name="order_no" value="0" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 focus:border-blue-600 outline-none text-sm font-semibold">
            </div>
        </div>
    </div>

    <div class="bg-white p-8 rounded-[2rem] border border-slate-100 shadow-sm grid md:grid-cols-2 gap-8">
        <div class="space-y-4">
            <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Hizmet Fotoğrafı</label>
            <div class="relative group border-2 border-dashed border-slate-100 rounded-2xl p-6 bg-slate-50/50 hover:bg-white transition-all flex flex-col items-center justify-center">
                <svg class="w-6 h-6 text-slate-300 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                <input type="file" name="image" class="text-[10px] text-slate-400">
            </div>
        </div>
        <div class="space-y-2">
            <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">SVG İkon Kodu</label>
            <textarea name="icon" rows="4" placeholder="<svg>...</svg>" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-[10px] font-mono leading-relaxed focus:border-blue-600 transition-all"></textarea>
        </div>
    </div>

    <div class="bg-white p-8 rounded-[2rem] border border-slate-100 shadow-sm space-y-4">
        <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Hizmet Açıklaması</label>
        <textarea name="description" rows="5" required placeholder="Hizmetin kapsamını buraya yazın..." class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 focus:border-blue-600 outline-none text-sm font-medium leading-relaxed resize-none transition-all"></textarea>
    </div>

    <button type="submit" class="w-full bg-slate-900 text-white py-5 rounded-2xl font-bold text-[10px] uppercase tracking-[0.3em] hover:bg-blue-600 transition-all shadow-xl shadow-slate-100">
        Hizmeti Kaydet
    </button>

</form>

<?php include 'includes/footer.php'; ?>