<?php 
require_once 'auth.php'; 
require_once '../includes/db.php';
include 'includes/header.php'; 

$id = $_GET['id'];
$service = $db->prepare("SELECT * FROM services WHERE id = ?");
$service->execute([$id]);
$s = $service->fetch(PDO::FETCH_ASSOC);

if (!$s) { header("Location: services.php"); exit; }
?>

<div class="mb-10 flex items-center justify-between">
    <div>
        <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-1">Düzenleme Modu</p>
        <h1 class="text-2xl font-bold text-slate-900 tracking-tight">Hizmeti Güncelle</h1>
    </div>
    <a href="services.php" class="text-slate-400 hover:text-slate-900 transition-colors">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M6 18L18 6M6 6l12 12"></path></svg>
    </a>
</div>

<form action="process.php?action=update_service" method="POST" enctype="multipart/form-data" class="space-y-6 max-w-4xl pb-20">
    <input type="hidden" name="id" value="<?php echo $s['id']; ?>">
    
    <div class="bg-white p-8 rounded-[2rem] border border-slate-100 shadow-sm grid md:grid-cols-2 gap-6">
        <div class="space-y-2">
            <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Hizmet Başlığı</label>
            <input type="text" name="title" value="<?php echo htmlspecialchars($s['title']); ?>" required class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 focus:border-blue-600 outline-none transition-all text-sm font-semibold">
        </div>
        <div class="space-y-2">
            <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Sıralama</label>
            <input type="number" name="order_no" value="<?php echo $s['order_no']; ?>" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 focus:border-blue-600 outline-none text-sm font-semibold">
        </div>
    </div>

    <div class="bg-white p-8 rounded-[2rem] border border-slate-100 shadow-sm grid md:grid-cols-2 gap-8">
        <div class="space-y-4">
            <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Hizmet Fotoğrafı</label>
            
            <?php if(!empty($s['image'])): ?>
                <div class="w-24 h-24 rounded-2xl overflow-hidden border border-slate-100 mb-4 shadow-sm">
                    <img src="../assets/img/<?php echo $s['image']; ?>" class="w-full h-full object-cover">
                </div>
            <?php endif; ?>

            <div class="relative group border-2 border-dashed border-slate-100 rounded-2xl p-6 bg-slate-50/50 hover:bg-white transition-all flex flex-col items-center justify-center text-center">
                <span class="text-[9px] font-bold text-slate-400 uppercase mb-2">Yeni Resim Seç (Opsiyonel)</span>
                <input type="file" name="image" class="text-[10px] text-slate-400">
            </div>
        </div>

        <div class="space-y-2">
            <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">SVG İkon Kodu</label>
            <textarea name="icon" rows="6" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-[10px] font-mono leading-relaxed focus:border-blue-600 transition-all"><?php echo $s['icon']; ?></textarea>
        </div>
    </div>

    <div class="bg-white p-8 rounded-[2rem] border border-slate-100 shadow-sm space-y-2">
        <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Hizmet Açıklaması</label>
        <textarea name="description" rows="6" required class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 focus:border-blue-600 outline-none text-sm font-medium leading-relaxed resize-none transition-all"><?php echo htmlspecialchars($s['description']); ?></textarea>
    </div>

    <button type="submit" class="w-full bg-blue-600 text-white py-5 rounded-2xl font-bold text-[10px] uppercase tracking-[0.3em] hover:bg-slate-900 transition-all shadow-xl shadow-blue-50">
        Değişiklikleri Uygula
    </button>
</form>

<?php include 'includes/footer.php'; ?>