<?php 
require_once 'auth.php'; 
require_once '../includes/db.php'; // Veritabanı bağlantısı
include 'includes/header.php'; 

// Hizmetleri çek
$services = $db->query("SELECT * FROM services ORDER BY order_no ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="mb-10 flex items-center justify-between gap-4">
    <div>
        <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-1 leading-none">İçerik Yönetimi</p>
        <h1 class="text-2xl font-bold text-slate-900 tracking-tight leading-none">Hizmet Listesi</h1>
    </div>
    <a href="service_add.php" class="bg-slate-900 text-white px-6 py-3.5 rounded-xl font-bold text-[10px] uppercase tracking-widest hover:bg-blue-600 transition-all shadow-sm flex items-center gap-2">
        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2.5"><path d="M12 4v16m8-8H4"></path></svg>
        Yeni Hizmet Ekle
    </a>
</div>

<div class="bg-white border border-slate-100 rounded-[2rem] overflow-hidden shadow-sm">
    <table class="w-full text-left border-collapse">
        <thead class="bg-slate-50/50 border-b border-slate-100">
            <tr>
                <th class="px-8 py-5 text-[10px] font-bold text-slate-400 uppercase tracking-widest">Görsel / İkon</th>
                <th class="px-8 py-5 text-[10px] font-bold text-slate-400 uppercase tracking-widest">Hizmet Adı</th>
                <th class="px-8 py-5 text-[10px] font-bold text-slate-400 uppercase tracking-widest">Sıra</th>
                <th class="px-8 py-5 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-right">İşlemler</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-slate-50">
            <?php foreach($services as $s): ?>
            <tr class="hover:bg-slate-50/30 transition-colors group">
                <td class="px-8 py-5">
                    <div class="flex items-center gap-3">
                        <div class="w-12 h-12 rounded-xl bg-slate-50 border border-slate-100 overflow-hidden flex items-center justify-center">
                            <?php if(!empty($s['image'])): ?>
                                <img src="../assets/img/<?php echo $s['image']; ?>" class="w-full h-full object-cover">
                            <?php elseif(!empty($s['icon'])): ?>
                                <div class="w-6 h-6 text-blue-600"><?php echo $s['icon']; ?></div>
                            <?php else: ?>
                                <svg class="w-5 h-5 text-slate-200" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                            <?php endif; ?>
                        </div>
                    </div>
                </td>
                <td class="px-8 py-5">
                    <span class="text-sm font-bold text-slate-700"><?php echo htmlspecialchars($s['title']); ?></span>
                </td>
                <td class="px-8 py-5">
                    <span class="text-xs font-bold text-slate-400">#<?php echo $s['order_no']; ?></span>
                </td>
                <td class="px-8 py-5 text-right space-x-1">
                    <a href="service_edit.php?id=<?php echo $s['id']; ?>" class="inline-flex p-2 text-slate-300 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition-all">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2.5"><path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                    </a>
                    <a href="process.php?action=delete_service&id=<?php echo $s['id']; ?>" onclick="return confirm('Silinsin mi?')" class="inline-flex p-2 text-slate-300 hover:text-red-600 hover:bg-red-50 rounded-lg transition-all">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2.5"><path d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                    </a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include 'includes/footer.php'; ?>