<?php 
require_once 'auth.php'; 
require_once '../includes/db.php';
include 'includes/header.php'; 

// Veriyi çekiyoruz ve $settings değişkenine atıyoruz
$settings = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

// Eğer veritabanında ID'si 1 olan ayar yoksa boş dönmemesi için kontrol
if (!$settings) {
    echo "Hata: Ayarlar tablosunda ID=1 olan veri bulunamadı!";
    exit;
}
?>

<div class="mb-12">
    <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-2 leading-none">Yapılandırma Merkezi</p>
    <h1 class="text-2xl font-bold text-slate-900 tracking-tight leading-none">Genel Ayarlar</h1>
</div>

<form action="process.php?action=update_settings" method="POST" enctype="multipart/form-data" class="space-y-8 max-w-4xl pb-20">
    
    <div class="bg-white border border-slate-100 rounded-[2rem] p-8 shadow-sm">
        <div class="flex items-center gap-3 mb-8 border-b border-slate-50 pb-5">
            <div class="w-8 h-8 bg-blue-50 text-blue-600 rounded-lg flex items-center justify-center">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
            </div>
            <h3 class="text-xs font-bold text-slate-900 uppercase tracking-widest">Site Kimliği ve Görseller</h3>
        </div>
        
        <div class="grid md:grid-cols-2 gap-8">
            <div class="space-y-2">
                <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Site Başlığı</label>
                <input type="text" name="site_title" value="<?php echo htmlspecialchars($settings['site_title']); ?>" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold focus:border-blue-600 transition-all">
            </div>
            <div class="space-y-2">
                <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Site Adresi (URL)</label>
                <input type="text" name="site_url" value="<?php echo htmlspecialchars($settings['site_url']); ?>" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold focus:border-blue-600 transition-all">
            </div>
            <div class="space-y-2">
                <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Logo Seç</label>
                <input type="file" name="site_logo" class="text-[10px] text-slate-400 block mt-2">
            </div>
            <div class="space-y-2">
                <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Favicon Seç</label>
                <input type="file" name="site_favicon" class="text-[10px] text-slate-400 block mt-2">
            </div>
        </div>
    </div>

    <div class="bg-white border border-slate-100 rounded-[2rem] p-8 shadow-sm">
        <div class="flex items-center gap-3 mb-8 border-b border-slate-50 pb-5">
            <div class="w-8 h-8 bg-blue-50 text-blue-600 rounded-lg flex items-center justify-center">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg>
            </div>
            <h3 class="text-xs font-bold text-slate-900 uppercase tracking-widest">Hakkımızda Metni</h3>
        </div>
        <div class="space-y-2">
            <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Firma Hikayesi ve Vizyon</label>
            <textarea name="about_text" rows="8" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-medium leading-relaxed resize-none focus:border-blue-600 transition-all"><?php echo htmlspecialchars($settings['about_text'] ?? ''); ?></textarea>
        </div>
    </div>

    <div class="bg-white border border-slate-100 rounded-[2rem] p-8 shadow-sm">
        <div class="flex items-center gap-3 mb-8 border-b border-slate-50 pb-5">
            <div class="w-8 h-8 bg-blue-50 text-blue-600 rounded-lg flex items-center justify-center">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 01-2 2h2a2 2 0 012-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v16m-6 0a2 2 0 002 2h2a2 2 0 002-2z"></path></svg>
            </div>
            <h3 class="text-xs font-bold text-slate-900 uppercase tracking-widest">Canlı İstatistikler</h3>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="space-y-2">
                <label class="text-[9px] font-bold text-slate-400 uppercase tracking-widest ml-1">Tamamlanan İş</label>
                <input type="text" name="stats_projects" value="<?php echo htmlspecialchars($settings['stats_projects'] ?? ''); ?>" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold focus:border-blue-600 transition-all">
            </div>
            <div class="space-y-2">
                <label class="text-[9px] font-bold text-slate-400 uppercase tracking-widest ml-1">Sektörel Tecrübe</label>
                <input type="text" name="stats_experience" value="<?php echo htmlspecialchars($settings['stats_experience'] ?? ''); ?>" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold focus:border-blue-600 transition-all">
            </div>
            <div class="space-y-2">
                <label class="text-[9px] font-bold text-slate-400 uppercase tracking-widest ml-1">Müşteri Sayısı</label>
                <input type="text" name="stats_clients" value="<?php echo htmlspecialchars($settings['stats_clients'] ?? ''); ?>" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold focus:border-blue-600 transition-all">
            </div>
        </div>
    </div>

    <div class="bg-white border border-slate-100 rounded-[2rem] p-8 shadow-sm">
        <div class="flex items-center gap-3 mb-8 border-b border-slate-50 pb-5">
            <div class="w-8 h-8 bg-blue-50 text-blue-600 rounded-lg flex items-center justify-center">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
            </div>
            <h3 class="text-xs font-bold text-slate-900 uppercase tracking-widest">İletişim Kanalları</h3>
        </div>
        <div class="grid md:grid-cols-2 gap-6">
            <input type="email" name="site_email" value="<?php echo htmlspecialchars($settings['site_email']); ?>" placeholder="E-Posta" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold">
            <input type="text" name="site_phone" value="<?php echo htmlspecialchars($settings['site_phone']); ?>" placeholder="Telefon" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold">
            <textarea name="site_address" rows="3" placeholder="Açık Adres" class="w-full md:col-span-2 px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold"><?php echo htmlspecialchars($settings['site_address']); ?></textarea>
        </div>
    </div>
<div class="bg-white border border-slate-100 rounded-[2rem] p-8 shadow-sm">
    <h3 class="text-xs font-bold text-slate-900 uppercase tracking-widest mb-6">SEO Yapılandırması</h3>
    <div class="space-y-4">
        <input type="text" name="seo_title" value="<?php echo $settings['seo_title']; ?>" placeholder="Meta Başlık" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold">
        <textarea name="seo_desc" rows="3" placeholder="Meta Açıklama" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold"><?php echo $settings['seo_desc']; ?></textarea>
        <input type="text" name="seo_keywords" value="<?php echo $settings['seo_keywords']; ?>" placeholder="Anahtar Kelimeler (virgülle ayır)" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold">
    </div>
</div>

<div class="bg-white border border-slate-100 rounded-[2rem] p-8 shadow-sm">
    <h3 class="text-xs font-bold text-slate-900 uppercase tracking-widest mb-6">Hero (Giriş) Görseli</h3>
    <div class="flex items-center gap-6">
        <?php if($settings['hero_image']): ?>
            <img src="../assets/img/<?php echo $settings['hero_image']; ?>" class="w-24 h-16 rounded-xl object-cover">
        <?php endif; ?>
        <input type="file" name="hero_image" class="text-xs">
    </div>
</div>
    <button type="submit" class="w-full bg-blue-600 text-white py-5 rounded-2xl font-bold text-xs uppercase tracking-[0.3em] hover:bg-slate-900 transition-all shadow-xl shadow-blue-50">
        Tüm Değişiklikleri Kaydet ve Yayınla
    </button>
</form>

<?php include 'includes/footer.php'; ?>