<footer class="bg-white pt-24 pb-12 border-t border-slate-50">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-16 mb-20">
            <div class="md:col-span-2">
                <a href="index.php" class="inline-block mb-8">
                    <?php if($site['site_logo']): ?>
                        <img src="assets/img/<?php echo $site['site_logo']; ?>" alt="Logo" class="h-8 w-auto">
                    <?php else: ?>
                        <span class="font-heading text-xl font-black uppercase"><?php echo $site['site_title']; ?></span>
                    <?php endif; ?>
                </a>
                <p class="text-slate-400 text-sm font-medium leading-relaxed max-w-sm">
                    Geleceğin iş dünyasına bugün adım atın. <?php echo htmlspecialchars($site['site_title']); ?> ile profesyonel çözümler her zaman yanınızda.
                </p>
            </div>

            <div>
                <h4 class="text-[10px] font-black uppercase tracking-[0.4em] text-slate-300 mb-8">Menü</h4>
                <ul class="space-y-4 text-xs font-bold text-slate-500 uppercase tracking-widest">
                    <li><a href="index.php" class="hover:text-blue-600 transition">Ana Sayfa</a></li>
                    <li><a href="#hizmetler" class="hover:text-blue-600 transition">Hizmetler</a></li>
                </ul>
            </div>

            <div>
                <h4 class="text-[10px] font-black uppercase tracking-[0.4em] text-slate-300 mb-8">İletişim</h4>
                <ul class="space-y-4 text-xs font-bold text-slate-500 uppercase tracking-widest">
                    <li class="flex items-center gap-2">
                        <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                        <?php echo $site['site_phone']; ?>
                    </li>
                    <li class="flex items-center gap-2">
                        <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                        <?php echo $site['site_email']; ?>
                    </li>
                </ul>
            </div>
        </div>

        <div class="pt-10 border-t border-slate-50 flex flex-col md:flex-row justify-between items-center gap-8">
            <p class="text-[10px] font-bold text-slate-300 uppercase tracking-widest">
                &copy; <?php echo date('Y'); ?> <?php echo htmlspecialchars($site['site_title']); ?>.
            </p>

            <a href="https://instagram.com/klcburak.0" target="_blank" class="flex items-center gap-4 group">
                <span class="text-[10px] font-black text-slate-300 uppercase tracking-[0.2em] group-hover:text-blue-600 transition-colors">Developed by</span>
                <div class="bg-slate-50 border border-slate-100 px-5 py-2.5 rounded-2xl group-hover:border-blue-600 transition-all flex items-center gap-3">
                    <svg class="w-4 h-4 text-slate-400 group-hover:text-blue-600 transition-colors" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
                    <span class="text-[11px] font-black text-slate-800 tracking-tight italic">@klcburak.0</span>
                </div>
            </a>
        </div>
    </div>
</footer>

<script>
    // Smooth scroll için minik bi dokunuş
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            document.querySelector(this.getAttribute('href')).scrollIntoView({
                behavior: 'smooth'
            });
        });
    });
</script>
</body>
</html>