<?php
require_once 'includes/db.php';

// Site ayarlarını çekiyoruz
$site = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

// Sayfayı belirliyoruz
$page = $_GET['page'] ?? 'home';

// URL isimlerini sekme başlığına çeviriyoruz
$page_titles = [
    'home'      => 'Ana Sayfa',
    'about'     => 'Hakkımızda',
    'services'  => 'Hizmetlerimiz',
    'portfolio' => 'Projelerimiz',
    'contact'   => 'İletişim'
];

// Temiz başlığı oluşturuyoruz
$current_page_name = $page_titles[$page] ?? 'Kurumsal';
$browser_title = $current_page_name . " | " . $site['site_title'];

// Header'ı dahil ediyoruz (browser_title artık header'a gidiyor)
include 'includes/header.php';

// İçerik sayfasını çağırıyoruz
if(file_exists("pages/$page.php")) {
    include "pages/$page.php";
} else {
    include "pages/home.php";
}

include 'includes/footer.php';
?>