<section class="pt-40 pb-16 lg:pt-52 lg:pb-24 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <div class="max-w-3xl">
            <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-3">Kurumsal Kimlik</p>
            <h1 class="font-heading text-3xl lg:text-5xl font-900 leading-tight tracking-tighter text-slate-900 uppercase">
                Geleceği Modern <br> <span class="text-blue-600">Çizgilerle İnşa Ediyoruz.</span>
            </h1>
        </div>
    </div>
</section>

<section class="pb-24 bg-white">
    <div class="max-w-7xl mx-auto px-8 grid lg:grid-cols-2 gap-20 items-start">
        
        <div class="space-y-8">
            <div class="space-y-4 text-slate-500 text-sm leading-relaxed font-medium">
                <p>
                    <?php echo nl2br(htmlspecialchars($site['about_text'] ?? 'Kurumsal içeriğimiz yakında burada olacaktır.')); ?>
                </p>
            </div>
            
            <div class="pt-8 border-t border-slate-50">
                <p class="font-heading text-lg font-800 text-slate-900 uppercase tracking-tighter">
                    Sadelik, en yüksek <br> <span class="text-blue-600">gelişmişlik düzeyidir.</span>
                </p>
            </div>
        </div>

        <div class="grid gap-6">
            <div class="p-6 rounded-2xl bg-slate-50/50 border border-slate-100 flex gap-5 items-center group hover:bg-white hover:border-blue-600 transition-all">
                <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center text-blue-600 shadow-sm border border-slate-100 group-hover:bg-blue-600 group-hover:text-white transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path></svg>
                </div>
                <div>
                    <h4 class="text-xs font-bold text-slate-900 uppercase tracking-widest">Güvenilirlik</h4>
                    <p class="text-[11px] text-slate-400 font-medium mt-1">Her adımda şeffaf ve kararlı bir süreç.</p>
                </div>
            </div>

            <div class="p-6 rounded-2xl bg-slate-50/50 border border-slate-100 flex gap-5 items-center group hover:bg-white hover:border-blue-600 transition-all">
                <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center text-blue-600 shadow-sm border border-slate-100 group-hover:bg-blue-600 group-hover:text-white transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
                </div>
                <div>
                    <h4 class="text-xs font-bold text-slate-900 uppercase tracking-widest">İnovasyon</h4>
                    <p class="text-[11px] text-slate-400 font-medium mt-1">En son teknolojileri projelerinize entegre ediyoruz.</p>
                </div>
            </div>

            <div class="p-6 rounded-2xl bg-slate-50/50 border border-slate-100 flex gap-5 items-center group hover:bg-white hover:border-blue-600 transition-all">
                <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center text-blue-600 shadow-sm border border-slate-100 group-hover:bg-blue-600 group-hover:text-white transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-7.714 2.143L11 21l-2.286-6.857L1 12l7.714-2.143L11 3z"></path></svg>
                </div>
                <div>
                    <h4 class="text-xs font-bold text-slate-900 uppercase tracking-widest">Kalite</h4>
                    <p class="text-[11px] text-slate-400 font-medium mt-1">Detaylardaki özen, sonucun kusursuzluğunu belirler.</p>
                </div>
            </div>
        </div>

    </div>
</section>

<section class="py-20 border-t border-slate-50 bg-white">
    <div class="max-w-7xl mx-auto px-8 grid grid-cols-2 lg:grid-cols-4 gap-12">
        <div class="text-center lg:text-left">
            <p class="text-3xl font-black text-slate-900 tracking-tighter"><?php echo htmlspecialchars($site['stats_projects'] ?? '0'); ?></p>
            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-[0.2em] mt-2">Tamamlanan Proje</p>
        </div>
        <div class="text-center lg:text-left">
            <p class="text-3xl font-black text-slate-900 tracking-tighter"><?php echo htmlspecialchars($site['stats_experience'] ?? '0'); ?></p>
            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-[0.2em] mt-2">Yıllık Tecrübe</p>
        </div>
        <div class="text-center lg:text-left">
            <p class="text-3xl font-black text-slate-900 tracking-tighter"><?php echo htmlspecialchars($site['stats_clients'] ?? '0'); ?></p>
            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-[0.2em] mt-2">Müşteri Memnuniyeti</p>
        </div>
        <div class="text-center lg:text-left">
            <p class="text-3xl font-black text-slate-900 tracking-tighter">24/7</p>
            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-[0.2em] mt-2">Kesintisiz Destek</p>
        </div>
    </div>
</section>