<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

$taskId = $input['task_id'] ?? null;
$title = $input['title'] ?? null;
$description = $input['description'] ?? '';
$priority = $input['priority'] ?? 'medium';
$color = $input['color'] ?? '#3b82f6';

if (!$taskId || !$title) {
    echo json_encode(['success' => false, 'message' => 'Görev ID ve başlık gerekli']);
    exit;
}

$validPriorities = ['low', 'medium', 'high'];
if (!in_array($priority, $validPriorities)) {
    $priority = 'medium';
}

try {
    $pdo = getDBConnection();
    
    $stmt = $pdo->prepare("SELECT id FROM tasks WHERE id = ?");
    $stmt->execute([$taskId]);
    
    if (!$stmt->fetch()) {
        echo json_encode(['success' => false, 'message' => 'Görev bulunamadı']);
        exit;
    }
    
    $stmt = $pdo->prepare("UPDATE tasks SET title = ?, description = ?, priority = ?, color = ?, updated_at = NOW() WHERE id = ?");
    $stmt->execute([
        htmlspecialchars($title),
        htmlspecialchars($description),
        $priority,
        $color,
        $taskId
    ]);
    
    $stmt = $pdo->prepare("SELECT * FROM tasks WHERE id = ?");
    $stmt->execute([$taskId]);
    $task = $stmt->fetch();
    
    echo json_encode(['success' => true, 'message' => 'Görev güncellendi', 'task' => $task]);
    
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Veritabanı hatası']);
}