-- Kanban To-Do List Veritabanı Yapısı
-- MySQL / MariaDB için

-- Veritabanını oluştur (eğer yoksa)
CREATE DATABASE IF NOT EXISTS kanban_db 
CHARACTER SET utf8mb4 
COLLATE utf8mb4_unicode_ci;

USE kanban_db;

-- Mevcut tabloyu sil (temiz kurulum için)
DROP TABLE IF EXISTS tasks;

-- Görevler tablosu
CREATE TABLE tasks (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    status ENUM('todo', 'inprogress', 'done') DEFAULT 'todo',
    priority ENUM('low', 'medium', 'high') DEFAULT 'medium',
    color VARCHAR(7) DEFAULT '#6366f1',
    position INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Örnek veriler
INSERT INTO tasks (title, description, status, priority, color, position) VALUES
('Proje planı hazırla', 'Q1 için detaylı proje planı oluştur', 'todo', 'high', '#ef4444', 0),
('Tasarım mockupları', 'Ana sayfa ve dashboard tasarımlarını hazırla', 'todo', 'medium', '#f59e0b', 1),
('API geliştirme', 'REST API endpoint''lerini kodla', 'inprogress', 'high', '#ef4444', 0),
('Veritabanı optimizasyonu', 'Query performansını artır', 'inprogress', 'medium', '#6366f1', 1),
('Unit testler', 'Tüm modüller için test yaz', 'done', 'low', '#22c55e', 0),
('Dokümantasyon', 'Kullanıcı kılavuzu hazırla', 'done', 'medium', '#6366f1', 1);

-- İndeksler (performans için)
CREATE INDEX idx_status ON tasks(status);
CREATE INDEX idx_position ON tasks(position);
CREATE INDEX idx_created_at ON tasks(created_at);